﻿using System;
using System.Runtime.InteropServices;

//Reference: https://docs.microsoft.com/en-us/windows/win32/api/winuser/nf-winuser-messagebox

public enum CustomMessageBoxButtons : long
{
    AbortRetryIgnore = 0x00000002L,
    CancelTryContinue = 0x00000006L,
    Help = 0x00004000L,
    OK = 0x00000000L,
    OKCancel = 0x00000001L,
    RetryCancel = 0x00000005L,
    YesNo = 0x00000004L,
    YesNoCancel = 0x00000003L
}

public enum CustomMessageBoxIcons : long
{
    Exclamation = 0x00000030L,
    Information = 0x00000040L,
    Error = 0x00000010L
}

public class CustomMessageBox
{
    //Import from user32.dll
    [System.Runtime.InteropServices.DllImport("user32.dll")]
    private static extern System.IntPtr GetActiveWindow();
    [DllImport("user32.dll", SetLastError = true)]
    private static extern int MessageBox(IntPtr hwnd, String lpText, String lpCaption, uint uType);

    public static System.IntPtr GetWindowHandle()
    {
        return GetActiveWindow();
    }

    /// <summary>
    /// Shows a Windows MessageBox with the desired text, caption, buttons and icon
    /// </summary>
    /// <param name="text"></param>
    /// <param name="caption"></param>
    /// <param name="buttons"></param>
    /// <param name="icon"></param>
    /// <returns></returns>
    public string Show(string text, string caption, CustomMessageBoxButtons buttons = CustomMessageBoxButtons.OK, CustomMessageBoxIcons icon = CustomMessageBoxIcons.Information)
    {
        try
        {
            int intResult = -1;
            string strResult = string.Empty;

            intResult = MessageBox(GetWindowHandle(), text, caption, (uint)((long)buttons | (long)icon));   //Pass in the text, caption, buttons and icon into the function, wait for the result

            //Get the string of the result
            switch (intResult)
            {
                case 1:
                    strResult = "OK";
                    break;
                case 2:
                    strResult = "CANCEL";
                    break;
                case 3:
                    strResult = "ABORT";
                    break;
                case 4:
                    strResult = "RETRY";
                    break;
                case 5:
                    strResult = "IGNORE";
                    break;
                case 6:
                    strResult = "YES";
                    break;
                case 7:
                    strResult = "NO";
                    break;
                case 10:
                    strResult = "TRY AGAIN";
                    break;
                default:
                    strResult = "OK";
                    break;
            }

            return strResult;
        }

        catch
        {
            return string.Empty;
        }
    }
}
